BuyableGpsConfigurationHandler = {}

function BuyableGpsConfigurationHandler.getConfigurationsFromXML(self, superfunc, xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
    local configurations, defaultConfigurationIds = superfunc(self, xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem) -- ALWAYS CALL BASE GAME FUNCTION (superFunc) AND RETURN THE RESULTS FROM YOUR METHOD, EVEN IF YOU DON'T MAKE ANY MODIFICATIONS !!!

    if configurations ~= nil
        and xmlFile:hasProperty("vehicle.enterable")
        and xmlFile:hasProperty("vehicle.motorized")
        and xmlFile:hasProperty("vehicle.drivable")
    then
        local buyableGpsConfigFile = XMLFile.load(BuyableGPS.CONFIGURATION_XML_KEY, BuyableGPS.CONFIGURATION_XML_PATH, xmlFile.schema)

        local allConfigs = self:getConfigurations()
        local buyableGpsConfig = allConfigs[BuyableGPS.CONFIGURATION_XML_KEY]

        if buyableGpsConfig ~= nil then
            local configItems = {}
            local i = 0

            while true do
                local xmlKey = string.format(buyableGpsConfig.configurationKey .. "(%d)", i)

                if not buyableGpsConfigFile:hasProperty(xmlKey) or i > 1 then
                    break
                end

                local configItem = buyableGpsConfig.itemClass.new(buyableGpsConfig.name)
                configItem:setIndex(#configItems + 1)

                if configItem:loadFromXML(buyableGpsConfigFile, buyableGpsConfig.configurationsKey, xmlKey, baseDir, customEnvironment) then
                    if i == 0 then
                        configItem.name = g_i18n.modEnvironments[BuyableGPS.MOD_NAME]:getText("BYGPS_CONFIG_NOT_INSTALLED_NAME_TEXT")
                        configItem.desc = g_i18n.modEnvironments[BuyableGPS.MOD_NAME]:getText("BYGPS_CONFIG_NOT_INSTALLED_DESCRIPTION_TEXT")
                    else
                        configItem.name = g_i18n.modEnvironments[BuyableGPS.MOD_NAME]:getText("BYGPS_CONFIG_INSTALLED_NAME_TEXT")
                        configItem.desc = g_i18n.modEnvironments[BuyableGPS.MOD_NAME]:getText("BYGPS_CONFIG_INSTALLED_DESCRIPTION_TEXT")
                    end
                    table.insert(configItems, configItem)
                end

                i = i + 1
            end

            if #configItems > 0 then
                defaultConfigurationIds[buyableGpsConfig.name] = ConfigurationUtil.getDefaultConfigIdFromItems(configItems)
                configurations[buyableGpsConfig.name] = configItems
            end

            buyableGpsConfigFile:delete();
        end
    end

    return configurations, defaultConfigurationIds -- ALWAYS RETURN BASE GAME VALUES (EVEN IF YOU DON'T MAKE ANY MODIFICATIONS) !!!
end

ConfigurationUtil.getConfigurationsFromXML = Utils.overwrittenFunction(ConfigurationUtil.getConfigurationsFromXML, BuyableGpsConfigurationHandler.getConfigurationsFromXML)