-- ============================================================================
-- === AdblueInstaller.Lua
-- === Mod my [LSMT] Modding Team 
-- === LS25 /FS25
-- === Script by [LSMT] BaTt3RiE @ 2025
-- === Ver 1.0.0.0
-- === Fügt jedem Fahrzeug die AdBlue-Verbrauchs-Spezialisierung hinzu.
-- ============================================================================

local modDirectory = g_currentModDirectory or ""
local modName = g_currentModName or "unknown"

source(modDirectory .. "script/AdblueConsumer.lua")

local function initSpecialization(manager)
    if manager.typeName == "vehicle" then
        g_specializationManager:addSpecialization(
        "AdblueConsumer",
        "AdblueConsumer", modDirectory .. "script/AdblueConsumer.lua", nil)

        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
			if typeEntry ~= nil and typeName ~= "locomotive" and typeName ~= "trainTrailer" and typeName ~= "trainTimberTrailer" then
				if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations) and
                    SpecializationUtil.hasSpecialization(Enterable, typeEntry.specializations) and
                    SpecializationUtil.hasSpecialization(Motorized, typeEntry.specializations) and
                    not SpecializationUtil.hasSpecialization(Locomotive,     typeEntry.specializations) and
                    not SpecializationUtil.hasSpecialization(ConveyorBelt,   typeEntry.specializations) and
                    not SpecializationUtil.hasSpecialization(AIConveyorBelt, typeEntry.specializations) 
                then
				    g_vehicleTypeManager:addSpecialization(typeName, modName .. ".AdblueConsumer")
			    end
            end
        end
    end
end

local function init()
    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, initSpecialization)
end

init()