-- ChangeHusbandryCapacity.lua
-- Special: cowHusbandryPasture= 25 Animals
-- Version: 1.0.0.0
-- by: Tidde

ChangeHusbandryCapacity = ChangeHusbandryCapacity or {}
if ChangeHusbandryCapacity.debug == nil then ChangeHusbandryCapacity.debug = false end
if ChangeHusbandryCapacity.hasLogged == nil then ChangeHusbandryCapacity.hasLogged = false end

--- Logging-Hilfen (Debug nur einmal beim Spielstart)
local function logInfo(fmt, ...)
    if not ChangeHusbandryCapacity.hasLogged and Logging ~= nil and Logging.info ~= nil then
        Logging.info("[ChangeHusbandryCapacity] " .. fmt, ...)
        ChangeHusbandryCapacity.hasLogged = true
    end
end

local function logWarning(fmt, ...)
    if Logging ~= nil and Logging.warning ~= nil then
        Logging.warning("[ChangeHusbandryCapacity] " .. fmt, ...)
    else
        print(string.format("[ChangeHusbandryCapacity][WARN] " .. fmt, ...))
    end
end

if PlaceableHusbandry == nil then
    logWarning("PlaceableHusbandry not found -> no capacity patch applied")
    return
end

local DEFAULTS = { FOOD= 1500, STRAW= 750, LIQUIDMANURE = 2000, WATER= 1500 }

local PER_SPECIES = {
    COW = {     FOOD= 1500, STRAW=  750, LIQUIDMANURE = 1750, WATER = 1500},
    PIG = {     FOOD=  750, STRAW=  500, LIQUIDMANURE =  600, WATER =  750},
    SHEEP = {   FOOD=  150, STRAW=   70, LIQUIDMANURE =    0, WATER =  300},
    CHICKEN = { FOOD=   15, STRAW=    0, LIQUIDMANURE =    0, WATER =   50},
    HORSE = {   FOOD= 1750, STRAW= 2500, LIQUIDMANURE =    0, WATER = 2000}
}

local function getPer(speciesKey, kind)
    local key = (type(speciesKey) == "string") and speciesKey:upper() or nil
    local per = key and PER_SPECIES[key] or nil
    return (per and per[kind]) or DEFAULTS[kind]
end

local function getSpeciesKey(self)
    local specFood = self.spec_husbandryFood
    if specFood ~= nil and specFood.animalTypeIndex ~= nil then
        if g_animalTypeManager ~= nil and g_animalTypeManager.getTypeByIndex ~= nil then
            local t = g_animalTypeManager:getTypeByIndex(specFood.animalTypeIndex)
            if t ~= nil then
                local name = t.name or t.typeName
                if type(name) == "string" and name ~= "" then
                    return name:upper()
                end
            end
        end

        if g_currentMission ~= nil and g_currentMission.animalSystem ~= nil
                and g_currentMission.animalSystem.getTypeByIndex ~= nil then
            local t = g_currentMission.animalSystem:getTypeByIndex(specFood.animalTypeIndex)
            if t ~= nil then
                local name = t.name or t.typeName
                if type(name) == "string" and name ~= "" then
                    return name:upper()
                end
            end
        end
    end

    if self.xmlFile ~= nil and self.xmlFile.getValue ~= nil then
        local xmlType = self.xmlFile:getValue("placeable.husbandry.animals#type")
        if type(xmlType) == "string" and xmlType ~= "" then
            return xmlType:upper()
        end
    end

    return nil
end

local function getMaxAnimals(self)
    if self.typeName == "cowHusbandryPasture" then
        return 20
    end

    if self.getMaxNumOfAnimals ~= nil then
        local n = self:getMaxNumOfAnimals()
        if n ~= nil and n > 0 then
            return n
        end
    end

    local sa = self.spec_husbandryAnimals
    if sa ~= nil and sa.maxNumOfAnimals ~= nil and sa.maxNumOfAnimals > 0 then
        return sa.maxNumOfAnimals
    end

    if self.xmlFile ~= nil and self.xmlFile.getValue ~= nil then
        local n = self.xmlFile:getValue("placeable.husbandry.animals#maxNumAnimals")
        if n ~= nil then
            n = tonumber(n)
            if n ~= nil and n > 0 then
                return n
            end
        end
    end

    return 0
end

local function patchFoodCapacity(self)
    local spec = self.spec_husbandryFood
    if spec == nil then
        return
    end

    local maxAnimals = getMaxAnimals(self)
    if maxAnimals <= 0 then
        return
    end

    local speciesKey = getSpeciesKey(self)
    local perFood    = getPer(speciesKey, "FOOD")

    if spec._chc_originalCapacity == nil then
        spec._chc_originalCapacity = spec.capacity
    end

    spec.capacity = maxAnimals * perFood
    spec._chc_maxAnimals = maxAnimals
end

local function patchHusbandryStorage(self)
    local specHus = self.spec_husbandry
    if specHus == nil then
        return
    end

    local storage = specHus.storage
    if type(storage) ~= "table" then
        return
    end

    if storage._chc_patched then
        return
    end
    storage._chc_patched = true

    local maxAnimals = getMaxAnimals(self)
    if maxAnimals <= 0 then
        return
    end

    local speciesKey = getSpeciesKey(self)

    local strawFillTypeIndex = nil
    if self.spec_husbandryStraw ~= nil then
        strawFillTypeIndex = self.spec_husbandryStraw.inputFillType
    end

    local lmFillTypeIndex = nil
    if self.spec_husbandryLiquidManure ~= nil then
        lmFillTypeIndex = self.spec_husbandryLiquidManure.fillType
    end

    local waterFillTypeIndex = nil
    if g_fillTypeManager ~= nil and g_fillTypeManager.getFillTypeIndexByName ~= nil then
        waterFillTypeIndex = g_fillTypeManager:getFillTypeIndexByName("WATER")
        if waterFillTypeIndex == nil then
            waterFillTypeIndex = g_fillTypeManager:getFillTypeIndexByName("water")
        end
    end

    if strawFillTypeIndex == nil and lmFillTypeIndex == nil and waterFillTypeIndex == nil then
        return
    end

    if storage._chc_orig_getCapacity == nil and type(storage.getCapacity) == "function" then
        storage._chc_orig_getCapacity = storage.getCapacity
    end
    local origGetCapacity = storage._chc_orig_getCapacity or storage.getCapacity

    if type(origGetCapacity) ~= "function" then
        return
    end

    local strawOrig = nil
    local lmOrig    = nil
    local waterOrig = nil

    if strawFillTypeIndex ~= nil then
        strawOrig = origGetCapacity(storage, strawFillTypeIndex) or 0
        if strawOrig <= 0 then
            strawFillTypeIndex = nil
        end
    end

    if lmFillTypeIndex ~= nil then
        lmOrig = origGetCapacity(storage, lmFillTypeIndex) or 0
        if lmOrig <= 0 then
            lmFillTypeIndex = nil
        end
    end

    if waterFillTypeIndex ~= nil then
        waterOrig = origGetCapacity(storage, waterFillTypeIndex) or 0
        if waterOrig <= 0 then
            waterFillTypeIndex = nil
        end
    end

    if strawFillTypeIndex == nil and lmFillTypeIndex == nil and waterFillTypeIndex == nil then
        return
    end

    local perStraw  = getPer(speciesKey, "STRAW")
    local perLM     = getPer(speciesKey, "LIQUIDMANURE")
    local perWater  = getPer(speciesKey, "WATER")

    local strawTarget  = (strawFillTypeIndex ~= nil)  and (maxAnimals * perStraw)  or nil
    local lmTarget     = (lmFillTypeIndex ~= nil)     and (maxAnimals * perLM)     or nil
    local waterTarget  = (waterFillTypeIndex ~= nil)  and (maxAnimals * perWater)  or nil

    local mods = {}

    local function addMod(fillTypeIndex, origCap, targetCap)
        if fillTypeIndex ~= nil and origCap ~= nil and targetCap ~= nil and targetCap > origCap then
            mods[fillTypeIndex] = { orig = origCap, target = targetCap }
        end
    end

    addMod(strawFillTypeIndex,  strawOrig,  strawTarget)
    addMod(lmFillTypeIndex,     lmOrig,     lmTarget)
    addMod(waterFillTypeIndex,  waterOrig,  waterTarget)

    if next(mods) == nil then
        return
    end

    local function bumpCapacityInTables(fillTypeIndex, origCap, targetCap)
        for _, v in pairs(storage) do
            if type(v) == "table" then
                local val = v[fillTypeIndex]
                if type(val) == "number" and math.abs(val - origCap) < 0.01 then
                    v[fillTypeIndex] = targetCap
                end
            end
        end
    end

    for ftIndex, info in pairs(mods) do
        bumpCapacityInTables(ftIndex, info.orig, info.target)
    end

    storage.getCapacity = function(selfStorage, fillTypeIndex)
        local base = 0
        if type(origGetCapacity) == "function" then
            base = origGetCapacity(selfStorage, fillTypeIndex) or 0
        end

        local mod = mods[fillTypeIndex]
        if mod ~= nil and mod.target ~= nil and mod.target > base then
            return mod.target
        end

        return base
    end

    if storage._chc_orig_getFreeCapacity == nil and type(storage.getFreeCapacity) == "function" then
        storage._chc_orig_getFreeCapacity = storage.getFreeCapacity
    end

    storage.getFreeCapacity = function(selfStorage, fillTypeIndex)
        local cap  = selfStorage:getCapacity(fillTypeIndex) or 0
        local fill = 0
        if type(selfStorage.getFillLevel) == "function" then
            fill = selfStorage:getFillLevel(fillTypeIndex) or 0
        end
        local free = cap - fill
        if free < 0 then free = 0 end
        return free
    end
end

local old_onFinalizePlacement = PlaceableHusbandry.onFinalizePlacement

function PlaceableHusbandry:onFinalizePlacement(...)
    if old_onFinalizePlacement ~= nil then
        old_onFinalizePlacement(self, ...)
    end

    patchFoodCapacity(self)
    patchHusbandryStorage(self)
end