-- Farmland Difficulty
-- @author GMNGjoy
-- @copyright 11/06/2025
-- @contact https://github.com/GMNGjoy/FS25_FarmlandDifficulty
-- @license CC BY-NC-SA 4.0 w/ Conversions Restricted
-- @license https://creativecommons.org/licenses/by-nc-sa/4.0/

MOD_NAME = g_currentModName or "unknown"
FarmlandDifficulty = {}
FarmlandDifficulty.debug = false
FarmlandDifficulty.DIFFICULTY_NAMES = { 'EASY', 'NORMAL', 'HARD' }

---Initializes Farmland Difficulty!
function FarmlandDifficulty:init()

    -- Override the FarmlandManager.getPricePerHa basegame function
    FarmlandManager.getPricePerHa = Utils.overwrittenFunction(FarmlandManager.getPricePerHa, FarmlandDifficulty.getPricePerHa)

    -- add a console command to toggle debug mode.
    addConsoleCommand("fdToggleDebug", "Toggles the debug mode within the Farmland Difficulty mod", "consoleCommandToggleDebug", FarmlandDifficulty)

    Logging.info(MOD_NAME..' :: INITIALIZED. debug: %s', FarmlandDifficulty.debug and "on" or "off")
end

---Replaces the default g_farmlandManager:getPricePerHa() function with our own.
function FarmlandDifficulty:getPricePerHa()
    local pricePerHa = g_farmlandManager.pricePerHa
    local difficulty = g_currentMission.missionInfo.economicDifficulty

    -- determine the new price for land, per hectare (based on the current pricePerHa)
    local newPricePerHa
    newPricePerHa = pricePerHa * EconomyManager.COST_MULTIPLIER[difficulty]

    if FarmlandDifficulty.debug then 
        Logging.info(MOD_NAME..' :: ADJUSTED PRICE: %s (was: %s) difficulty: %s', 
            newPricePerHa, pricePerHa, FarmlandDifficulty.DIFFICULTY_NAMES[difficulty])
    end

    return newPricePerHa
end

---Replaces the default g_farmlandManager:getPricePerHa() function with our own.
function FarmlandDifficulty:updateFarmlands()
    if FarmlandDifficulty.debug then Logging.info(MOD_NAME..' :: updateFarmlands when changing difficulty') end

    -- loop through the farmlands and update the prices, which will indirectly call the FarmlandDifficulty:getPricePerHa() fn.
    for _, farmland in g_farmlandManager.farmlands do
        farmland:updatePrice()
    end

    Logging.info(MOD_NAME..' :: FARMLAND COST UPDATED based on difficulty.')
end

---Add console command to toggle debug
function FarmlandDifficulty.consoleCommandToggleDebug()
    FarmlandDifficulty.debug = not FarmlandDifficulty.debug
    Logging.info(MOD_NAME..' :: DEBUG set %s', FarmlandDifficulty.debug and "On" or "Off")
end

---Initialize FarmlandDifficulty when the map has finished loading
BaseMission.loadMapFinished = Utils.prependedFunction(BaseMission.loadMapFinished, function(...)
    FarmlandDifficulty:init()
end)

---Save the config when the savegame is being saved
FSBaseMission.setEconomicDifficulty = Utils.appendedFunction(FSBaseMission.setEconomicDifficulty,  function(...)
    FarmlandDifficulty:updateFarmlands()
end)