FieldLeasingSettingsEvent = {}

local FieldLeasingSettingsEvent_mt = Class(FieldLeasingSettingsEvent, Event)
InitEventClass(FieldLeasingSettingsEvent, "FieldLeasingSettingsEvent")

function FieldLeasingSettingsEvent.emptyNew()
    return Event.new(FieldLeasingSettingsEvent_mt)
end

function FieldLeasingSettingsEvent.new()
    return FieldLeasingSettingsEvent.emptyNew()
end

function FieldLeasingSettingsEvent:readStream(streamId, connection)
	local priceMultiplier = streamReadFloat32(streamId)
	local minDuration = streamReadInt32(streamId)

	if connection:getIsServer() or g_currentMission.userManager:getIsConnectionMasterUser(connection) then
        g_fieldLeasingManager:updatePriceMultiplier(priceMultiplier, true)
        g_fieldLeasingManager:updateMinDuration(minDuration, true)

		if not connection:getIsServer() then
			g_server:broadcastEvent(self, false, connection)
		end
    end
end

function FieldLeasingSettingsEvent:writeStream(streamId, connection)
    streamWriteFloat32(streamId, g_fieldLeasingManager.priceMultiplier)
    streamWriteInt32(streamId, g_fieldLeasingManager.minDuration)
end

function FieldLeasingSettingsEvent.run(_, _)
    Logging.error("Error: FieldLeasingSettingsEvent is not allowed to be executed on a local client")
end

function FieldLeasingSettingsEvent.sendEvent(noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_currentMission:getIsServer() then
			g_server:broadcastEvent(FieldLeasingSettingsEvent.new(), false)
			return
		end
		g_client:getServerConnection():sendEvent(FieldLeasingSettingsEvent.new())
	end
end