--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 12.12.2019
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]


local buildId = 2
local versionString = "0.0.0.0"

local modName = g_currentModName or ""
local modDirectory = g_currentModDirectory or ""

local validationFail
local fillLevelLimiter

local invalidVehicleTypes = {
    ["car"] = true,
    ["baler"] = true,
    ["pallet"] = true,
    ["bigBag"] = true,
    ["tractor"] = true,
    ["leveler"] = true,
    ["woodTruck"] = true,
    ["forwarder"] = true,
    ["locomotive"] = true,
    ["teleHandler"] = true,
    ["buyableBale"] = true,
    ["treePlanter"] = true,
    ["strawBlower"] = true,
    ["conveyorBelt"] = true,
    ["balerWrapper"] = true,
    ["baseDrivable"] = true,
    ["loaderVehicle"] = true,
    ["woodHarvester"] = true,
    ["receivingHopper"] = true,
    ["combineDrivable"] = true,
    ["cottonHarvester"] = true,
    ["attachableCombine"] = true,
    ["treeSaplingPallet"] = true,
    ["pickupConveyorBelt"] = true,
    ["selfPropelledMower"] = true,
    ["tractorCrabSteering"] = true,
    ["tractorReverseDriving"] = true,
    ["combineCutterFruitPreparer"] = true,
    ["attachableCombineCutterFruitPreparer"] = true
}

local invalidClassNames = {
    ["Pallet"] = true,
    ["Baler"] = true,
    ["Mower"] = true,
    ["Leveler"] = true,
    ["Combine"] = true,
    ["StrawBlower"] = true,
    ["TreePlanter"] = true,
    ["BaleWrapper"] = true,
    ["InlineWrapper"] = true,
    ["MultipleItemPurchase"] = true
}

local function getIsValidVehicleType(typeName, specializations)
    -- Ignore invalid vehicle types and specialisations that conflict or are not required
    if invalidVehicleTypes[typeName] then
        return false
    end

    if specializations ~= nil then
        for _, specialization in pairs(specializations) do
            if invalidClassNames[specialization.className] then
                return false
            end
        end
    end

    return true
end

local function validateMod()
    local mod = g_modManager:getModByName(modName)

    if mod == nil or g_iconGenerator ~= nil or g_isEditor then
        return false
    end

    versionString = mod.version or versionString

    if mod.modName == "FS25_FillLevelLimiter" or mod.modName == "FS25_FillLevelLimiter_update" then
        if mod.author ~= nil and #mod.author == 3 then
            return true
        end
    end

    validationFail = {
        startUpdateTime = 2000,

        update = function(self, dt)
            self.startUpdateTime = self.startUpdateTime - dt

            if self.startUpdateTime < 0 then
                local text = string.format(g_i18n:getText("fll_loadError", mod.modName), mod.modName, mod.author or "Unknown")

                if g_dedicatedServer == nil then
                    if not g_gui:getIsGuiVisible() then
                        local title = string.format("%s - Version %s", mod.title, versionString)
                        local yesText = g_i18n:getText("button_modHubDownload")
                        local noText = g_i18n:getText("button_ok")

                        YesNoDialog.show(self.openModHubLink, nil, text, title, yesText, noText, DialogElement.TYPE_LOADING)
                    end
                else
                    print("\n" .. text .. "\n    - https://farming-simulator.com/mods.php?&title=fs2025&filter=org&org_id=129652&page=0" .. "\n")
                    self.openModHubLink(false)
                end
            end
        end,

        openModHubLink = function(yes)
            if yes then
                openWebFile("mods.php?title=fs2025&filter=org&org_id=129652&page=0", "")
            end

            removeModEventListener(validationFail)
            validationFail = nil
        end
    }

    addModEventListener(validationFail)

    return false
end

local function init()
    if g_globalMods == nil then
        g_globalMods = {}
    end

    if g_globalMods.fillLevelLimiter then
        Logging.error("Failed to load mod '%s', 'FillLevelLimiter' was already loaded by '%s'!", modName, g_globalMods.fillLevelLimiter.modName or "N/A")

        return
    end

    if validateMod() then
        fillLevelLimiter = {
            numInserted = 0,
            modName = modName,
            version = version,
            buildId = buildId
        }

        g_globalMods.fillLevelLimiter = fillLevelLimiter

        source(modDirectory .. "scripts/specializations/events/FillLevelLimiterEvent.lua")
        source(modDirectory .. "scripts/gui/FillLevelLimiterDialog.lua")

        g_specializationManager:addSpecialization("fillLevelLimiter", "FillLevelLimiter", modDirectory .. "scripts/specializations/FillLevelLimiter.lua", nil)

        TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, function(typeManager)
            if typeManager.typeName == "vehicle" and fillLevelLimiter ~= nil then
                local specializationName = FillLevelLimiter.SPEC_NAME
                local specializationObject = g_specializationManager:getSpecializationObjectByName(specializationName)

                if specializationObject ~= nil then
                    for typeName, typeEntry in pairs (typeManager:getTypes()) do
                        if typeEntry.specializationsByName[specializationName] == nil then
                            if getIsValidVehicleType(typeName, typeEntry.specializations) and specializationObject.prerequisitesPresent(typeEntry.specializations) then
                                typeManager:addSpecialization(typeName, specializationName)

                                fillLevelLimiter.numInserted = fillLevelLimiter.numInserted + 1
                            end
                        end
                    end

                    if fillLevelLimiter.numInserted > 0 then
                        FillLevelLimiterDialog.register()

                        Logging.info("[FillLevelLimiter] Specialisation has been added to %d vehicle types", fillLevelLimiter.numInserted)
                    end
                else
                    Logging.warning("[FillLevelLimiter] Failed to load vehicle specialisation, mod may not perform as intended!")
                end
            end
        end)

        FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, function(currentMission)
            g_globalMods.fillLevelLimiter = nil
            fillLevelLimiter = nil -- No need for a mod event listener just for delete
        end)
    else
        Logging.error("[%s] Failed to initialise / validate mod!", modName)
    end
end

init()
