hpSetGetSettingsXml = {};

function hpSetGetSettingsXml:loadConfig()
	createFolder(getUserProfileAppPath().. "modSettings/FS25_HeapPreview/");
	createFolder(HeapPreview.settingsDir);
	local file = HeapPreview.settingsDir.. "heapPreviewSettings.xml";	
	if not fileExists(file) then
		hpSetGetSettingsXml:saveConfig();
	else
		local Xml = loadXMLFile("HeapPreview_XML", file, "heapPreviewSettings");
		local groupNameTag = ("heapPreviewSettings.global(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#isOn") ~= nil then HeapPreview.values.isOn = getXMLBool(Xml, groupNameTag.. "#isOn");end;
		--if getXMLBool(Xml, groupNameTag.. "#hlDebugMode") ~= nil then HeapPreview.hlDebugMode = getXMLBool(Xml, groupNameTag.. "#hlDebugMode");end;
		groupNameTag = ("heapPreviewSettings.global.values.radius(%d)"):format(0);
		if getXMLInt(Xml, groupNameTag.. "#int") ~= nil then HeapPreview.values.radius = getXMLInt(Xml, groupNameTag.. "#int");end;
		groupNameTag = ("heapPreviewSettings.global.values.viewDebugCircle(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then HeapPreview.values.viewDebugCircle = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("heapPreviewSettings.global.values.onField(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then HeapPreview.values.onField = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("heapPreviewSettings.global.values.viewFillLevel(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then HeapPreview.values.viewFillLevel = getXMLBool(Xml, groupNameTag.. "#boolean");end;
		groupNameTag = ("heapPreviewSettings.global.values.viewIngameBox(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#boolean") ~= nil then HeapPreview.values.viewIngameBox = getXMLBool(Xml, groupNameTag.. "#boolean");end;
	end;	
end;

function hpSetGetSettingsXml:saveConfig()
	createFolder(getUserProfileAppPath().. "modSettings/FS25_HeapPreview");
	createFolder(HeapPreview.settingsDir);
	local file = HeapPreview.settingsDir.. "heapPreviewSettings.xml";
	local Xml = createXMLFile("HeapPreview_XML", file, "heapPreviewSettings");
	local groupNameTag = ("heapPreviewSettings.global(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.. "#isOn", HeapPreview.values.isOn);
	setXMLBool(Xml, groupNameTag.. "#hlDebugMode", HeapPreview.hlDebugMode);
	
	groupNameTag = ("heapPreviewSettings.global.values.radius(%d)"):format(0);
	setXMLInt(Xml, groupNameTag.. "#int", HeapPreview.values.radius);
	groupNameTag = ("heapPreviewSettings.global.values.viewDebugCircle(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.. "#boolean", HeapPreview.values.viewDebugCircle);
	groupNameTag = ("heapPreviewSettings.global.values.onField(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.. "#boolean", HeapPreview.values.onField);
	groupNameTag = ("heapPreviewSettings.global.values.viewFillLevel(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.. "#boolean", HeapPreview.values.viewFillLevel);
	groupNameTag = ("heapPreviewSettings.global.values.viewIngameBox(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.. "#boolean", HeapPreview.values.viewIngameBox);
	saveXMLFile(Xml);
end;


function hpSetGetSettingsXml:onCloseCallbackGuiMenue()
	
end;

function hpSetGetSettingsXml:onOpenCallbackGuiMenue()

end;

function hpSetGetSettingsXml:onSaveCallbackGuiMenue()
	hpSetGetSettingsXml:saveConfig();
end;
