--[[
Copyright (C) GtX (Andy), 2025

Author: GtX | Andy
Date: 01.05.2025
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

MoveAnimalsSettingsEvent = {}

local MoveAnimalsSettingsEvent_mt = Class(MoveAnimalsSettingsEvent, Event)
InitEventClass(MoveAnimalsSettingsEvent, "MoveAnimalsSettingsEvent")

function MoveAnimalsSettingsEvent.emptyNew()
    return Event.new(MoveAnimalsSettingsEvent_mt)
end

function MoveAnimalsSettingsEvent.new()
    return MoveAnimalsSettingsEvent.emptyNew()
end

function MoveAnimalsSettingsEvent:readStream(streamId, connection)
    for _, setting in ipairs (g_moveHusbandryAnimals.settings) do
        local state = streamReadUIntN(streamId, setting.numBits)

        if setting.setState ~= nil then
            setting:setState(state)
        end
    end

    self:run(connection)
end

function MoveAnimalsSettingsEvent:writeStream(streamId, connection)
    for _, setting in ipairs (g_moveHusbandryAnimals.settings) do
        streamWriteUIntN(streamId, setting.state, setting.numBits)
    end
end

function MoveAnimalsSettingsEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection)
    end

    g_messageCenter:publish(MessageType.MOVE_HUSBANDRY_ANIMALS_SETTINGS_CHANGED)
end

function MoveAnimalsSettingsEvent.sendEvent(noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(MoveAnimalsSettingsEvent.new(), false)
        else
            g_client:getServerConnection():sendEvent(MoveAnimalsSettingsEvent.new())
        end
    end
end
