--[[
    AttchImplementsManuallyGeneralSettingsFrame

    Adds the settings for the Attach Implements Manually mod to the general settings menu.

        @author:    BayernGamers
        @date:      07.06.2025
        @version:   1.0

        History:    v1.0 @07.06.2025 - initial implementation in FS25
                    -------------------------------------------------------------------------------------------

        License:    Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))
source(Utils.getFilename("scripts/AttachImplementsManuallySettings.lua", g_currentModDirectory))
source(Utils.getFilename("scripts/AttachImplementsManuallySettingsManager.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "AttachImplementsManuallyGeneralSettingsFrame.lua")

AttachImplementsManuallyGeneralSettingsFrame = {}

local isDedi = g_dedicatedServer ~= nil

if isDedi then
    log:printDevInfo("Running on dedicated server, skipping script", LoggingUtil.DEBUG_LEVELS.HIGH)
    return
end

function AttachImplementsManuallyGeneralSettingsFrame.loadMap()
    local settingsManager = AttachImplementsManuallySettingsManager.getInstance()
    local settings = AttachImplementsManuallySettings.new(settingsManager)

    settings:init()
end

addModEventListener(AttachImplementsManuallyGeneralSettingsFrame)