
FieldWorth = {}
g_fieldWorth = nil

local mt = Class(FieldWorth, AbstractFieldMission)

function FieldWorth.new(mission, messageCenter, farmlandManager)
	local self = setmetatable({}, mt)
	return self
end
function FieldWorth:fieldFruitType(fieldInfo)
	local fruitTypeIndex = fieldInfo.fruitTypeIndex
	local growthState = fieldInfo.growthState
	local yieldBonus = false
	local penalty = 0
	local bonus = 0
	local fruit = false
	local withered = false
	local yield = false
	local fertilized = false
	if fruitTypeIndex ~= FruitType.UNKNOWN then
		local fruitType = g_fruitTypeManager:getFruitTypeByIndex(fruitTypeIndex)
		--- Terménytípus
		--fruitType.fillType.title
		--print("Terménytípus: "..fruitType.fillType.title)
		--fruit = true
		local growthText = nil
		--- Betakarított
		if fruitType:getIsCut(growthState) then
			growthText = g_i18n:getText("ui_growthMapCut")
		--- Elszáradt
		elseif fruitType:getIsWithered(growthState) then
			growthText = g_i18n:getText("ui_growthMapWithered")
			penalty = penalty + 3
			withered = true
		--- Növekszik
		elseif fruitType:getIsGrowing(growthState) then
			growthText = g_i18n:getText("ui_growthMapGrowing")
			yieldBonus = true
		--- Levélzet eltávolítása
		elseif fruitType:getIsPreparable(growthState) then
			growthText = g_i18n:getText("ui_growthMapReadyToPrepareForHarvest")
			yieldBonus = true
		--- Betakarításra kész
		elseif fruitType:getIsHarvestable(growthState) then
			growthText = g_i18n:getText("ui_growthMapReadyToHarvest")
			yieldBonus = true
		end
		--- Növekedés
		if growthText ~= nil then
			--box:addLine(g_i18n:getText("ui_mapOverviewGrowth"), growthText)
			--print("Növekedés: "..growthText)
		end
	end
	local fieldGroundSystem = g_currentMission.fieldGroundSystem
	--- Hozambónusz
	if yieldBonus then
		local multiplier = fieldInfo:getHarvestScaleMultiplier() - 1
		local harvestPercent = MathUtil.round(multiplier * 100)
		yieldBonus = MathUtil.round(harvestPercent * 0.25)
		bonus = bonus + yieldBonus
		yield = true
	end
	--- Megtrágyázott
	if fieldInfo.sprayLevel >= 0 then
		local maxValue = fieldGroundSystem:getMaxValue(FieldDensityMap.SPRAY_LEVEL)
		local fertilizeRatio = fieldInfo.sprayLevel / maxValue
		print("sprayLevel "..fieldInfo.sprayLevel)
		print("maxValue "..maxValue)
		fertilizeBonus = MathUtil.round(fertilizeRatio * 0.05 * 100)
		print("fertilizeBonus "..fertilizeBonus)
		bonus = bonus + fertilizeBonus
		print("bonus "..bonus)
		fertilized = true
	end
	return penalty, bonus, fruit, withered, yield, yieldBonus, fertilized, fertilizeBonus
end
function FieldWorth:fieldActions(fieldInfo)
	local missionInfo = g_currentMission.missionInfo
	local penalty = 0
	local lime = false
	local plow = false
	local roller = false
	--- Meszet igényel - ui_growthMapNeedsLime
	if Platform.gameplay.useLimeCounter and (missionInfo.limeRequired and fieldInfo.limeLevel == 0) then
		penalty = penalty + 8
		lime = true
	end
	--- Szántást igényel - ui_growthMapNeedsPlowing
	if fieldInfo.plowLevel == 0 and missionInfo.plowingRequiredEnabled then
		penalty = penalty + 5
		plow = true
	end
	--- Hengerezést igényel - ui_growthMapNeedsRolling
	if Platform.gameplay.useRolling and fieldInfo.rollerLevel > 0 then
		penalty = penalty + 3
		roller = true
	end
	return penalty, lime, plow, roller
end
function FieldWorth:fieldWeed(fieldInfo)
	if g_currentMission.missionInfo.weedsEnabled then
		local weedSystem = g_currentMission.weedSystem
		local fieldInfoStates = weedSystem:getFieldInfoStates()
		local weedState = fieldInfo.weedState
		local fruitTypeIndex = fieldInfo.fruitTypeIndex or FruitType.UNKNOWN
		local growthState = fieldInfo.growthState or 0
		local weedText = nil
		if weedState ~= 0 then
			local fruitType
			if fruitTypeIndex == nil then
				fruitType = nil
			else
				fruitType = g_fruitTypeManager:getFruitTypeByIndex(fruitTypeIndex)
			end
			if Platform.gameplay.hasWeeder then
				--- Gyomláló kicsi
				if (fruitType == nil or fruitType:getIsWeedable(growthState)) and weedSystem:getWeederReplacements(false).weed.replacements[weedState] == 0 then
					weedText = g_i18n:getText("weed_destruction_weeder")
				end
				--- Kapa közepes
				if weedText == nil and (fruitType == nil or fruitType:getIsHoeable(growthState)) and weedSystem:getWeederReplacements(true).weed.replacements[weedState] == 0 then
					weedText = g_i18n:getText("weed_destruction_hoe")
				end
			end
			--- Gyomirtó azaz 3 fokozatú gaz nagy
			if weedText == nil and (fruitType == nil or fruitType:getIsGrowing(growthState)) then
				weedText = g_i18n:getText("weed_destruction_herbicide")
			end
			local weedTitle = fieldInfoStates[weedState]
			if weedTitle ~= nil then
				--box:addLine(weedTitle, weedText or "", true)
			end
		end
	else
		return
	end
end
function FieldWorth:setMapSelectionItem(superFunc, hotspot)
    if hotspot ~= nil and hotspot.isa ~= nil and hotspot:isa(FarmlandHotspot) then
        local farmland = hotspot:getFarmland()
        if farmland ~= nil then
			local posX = 0
			local posZ = 0
			if farmland.field ~= nil then
				posX = farmland.field.posX
				posZ = farmland.field.posZ
			elseif farmland.xWorldPos ~= nil and farmland.zWorldPos ~= nil then
				posX = farmland.xWorldPos
				posZ = farmland.zWorldPos
			else
				return
			end
			if self.fieldInfo == nil then
				self.fieldInfo = FieldState.new()
			end
			local fieldInfo = self.fieldInfo
			fieldInfo:update(posX, posZ)

			if farmland.basePrice == nil then
				farmland.basePrice = farmland.price
			end
			
			local fruitPenalty, bonus, fruit, withered, yield, yieldBonus, fertilized, fertilizeBonus = g_fieldWorth:fieldFruitType(fieldInfo)
			local penalty, lime, plow, roller = g_fieldWorth:fieldActions(fieldInfo)
			g_fieldWorth:fieldWeed(fieldInfo)
			
			local totalPercent = 0
			totalPercent = totalPercent + bonus
			totalPercent = totalPercent - penalty - fruitPenalty
			totalPercent = totalPercent / 100
			farmland.price = farmland.basePrice * (1 + totalPercent)
			
			self.fieldWorthIssues = {}
			self.fieldWorthBonus  = {}
			if lime then
				table.insert(self.fieldWorthIssues, {key = "setting_limeRequired", percent = 8})
			end
			if plow then
				table.insert(self.fieldWorthIssues, {key = "ui_growthMapNeedsPlowing", percent = 5})
			end
			if roller then
				table.insert(self.fieldWorthIssues, {key = "ui_growthMapNeedsRolling", percent = 3})
			end
			if withered then
				table.insert(self.fieldWorthIssues, {key = "ui_growthMapWithered", percent = 3})
			end

			if yield then
				table.insert(self.fieldWorthBonus, {key = "fieldInfo_yieldBonus", percent = yieldBonus})
			end
			if fertilized then
				table.insert(self.fieldWorthBonus, {key = "ui_growthMapFertilized", percent = fertilizeBonus})
			end
        end
    end
    superFunc(self, hotspot)
end
function FieldWorth.InGameMenuMapFramesetMapInputContext(self)
	self.contextActions[InGameMenuMapFrame.ACTIONS.BUY]["callback"] = g_fieldWorth.onClickBuy
	self.contextActions[InGameMenuMapFrame.ACTIONS.SELL]["callback"] = g_fieldWorth.onClickSell
end
function FieldWorth:onClickBuy(superFunc)
	if self.selectedFarmland == nil then
		return superFunc(self)
	else
		if g_missionManager:getIsMissionRunningOnFarmland(self.selectedFarmland) then
			InfoDialog.show(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_BUY_FARMLAND_ACTIVE_MISSION))
			return false
		end
		if self.playerFarm:getBalance() >= self.selectedFarmland.price then
			------------------------------------------------
			-- MOD
			------------------------------------------------
			local priceText = g_i18n:formatMoney(self.selectedFarmland.price, 0, true, true)
			local baseText = string.format(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_BUY_FARMLAND), priceText)
			local extra = {}
			local basePrice = self.selectedFarmland.basePrice
			local finalPrice = self.selectedFarmland.price
			local basePriceText = string.format(g_i18n:getText("FW_basePriceText"), g_i18n:formatMoney(basePrice, 0, true, true))
			if finalPrice > basePrice then
				table.insert(extra, g_i18n:getText("FW_extraIncreasedText"))
			elseif finalPrice < basePrice then
				table.insert(extra, g_i18n:getText("FW_extraReducedText"))
			end
			table.insert(extra, "")
			local function appendLines(list, sign)
				if list ~= nil then
					for _, e in ipairs(list) do
						local text = g_i18n:getText(e.key)
						table.insert(extra, string.format(
							"- %s (%s%0.0f%%)",
							text,
							sign,
							e.percent
						))
					end
				end
			end
			appendLines(self.fieldWorthBonus, "+") 
			appendLines(self.fieldWorthIssues, "-")
			local totalPercent = 0
			if self.fieldWorthBonus then
				for _, e in ipairs(self.fieldWorthBonus) do
					print(e.key.." "..e.percent)
					totalPercent = totalPercent + e.percent
				end
			end
			if self.fieldWorthIssues then
				for _, e in ipairs(self.fieldWorthIssues) do
					print(e.key.." "..e.percent)
					totalPercent = totalPercent - e.percent
				end
			end
			table.insert(extra, "")
			table.insert(extra, string.format(g_i18n:getText("FW_extraTotalText"), totalPercent))
			local extraText = ""
			if #extra > 0 then
				extraText = "\n\n" .. table.concat(extra, "\n")
			end
			local finalText = baseText .. basePriceText .. extraText
			YesNoDialog.show(self.onYesNoBuyFarmland, self, finalText, g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_BUY_FARMLAND_TITLE))
		else
			InfoDialog.show(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_BUY_FARMLAND_NOT_ENOUGH_MONEY), nil, nil, DialogElement.TYPE_WARNING)
		end
	end
	return true
end
function FieldWorth:onClickSell(superFunc)
	if self.selectedFarmland == nil then
		return superFunc(self)
	elseif g_currentMission.placeableSystem:getArePlaceablesOnFarmland(g_localPlayer.farmId, self.selectedFarmland.id) then
		InfoDialog.show(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_CANNOT_SELL_WTIH_PLACEABLES))
	else
		------------------------------------------------
		-- MOD
		------------------------------------------------
		local priceText = g_i18n:formatMoney(self.selectedFarmland.price, 0, true, true)
		local baseText = string.format(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_SELL_FARMLAND), priceText)
		local extra = {}
		local basePrice = self.selectedFarmland.basePrice
		local finalPrice = self.selectedFarmland.price
		local basePriceText = string.format(g_i18n:getText("FW_basePriceText"), g_i18n:formatMoney(basePrice, 0, true, true))
		if finalPrice > basePrice then
			table.insert(extra, g_i18n:getText("FW_extraIncreasedText"))
		elseif finalPrice < basePrice then
			table.insert(extra, g_i18n:getText("FW_extraReducedText"))
		end
		table.insert(extra, "")
		local function appendLines(list, sign)
			if list ~= nil then
				for _, e in ipairs(list) do
					local text = g_i18n:getText(e.key)
					table.insert(extra, string.format(
						"- %s (%s%0.0f%%)",
						text,
						sign,
						e.percent
					))
				end
			end
		end
		appendLines(self.fieldWorthBonus, "+") 
		appendLines(self.fieldWorthIssues, "-")
		local totalPercent = 0
		if self.fieldWorthBonus then
			for _, e in ipairs(self.fieldWorthBonus) do
				totalPercent = totalPercent + e.percent
			end
		end
		if self.fieldWorthIssues then
			for _, e in ipairs(self.fieldWorthIssues) do
				totalPercent = totalPercent - e.percent
			end
		end
		table.insert(extra, "")
		table.insert(extra, string.format(g_i18n:getText("FW_extraTotalText"), totalPercent))
		local extraText = ""
		if #extra > 0 then
			extraText = "\n\n" .. table.concat(extra, "\n")
		end
		local finalText = baseText .. basePriceText .. extraText
		YesNoDialog.show(self.onYesNoSellFarmland, self, finalText, g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_SELL_FARMLAND_TITLE))
	end
	return true
end

function mainLoad(mission)
	g_fieldWorth = FieldWorth:new(mission, g_messageCenter, g_farmlandManager)

	InGameMenuMapFrame.setMapSelectionItem = Utils.overwrittenFunction(InGameMenuMapFrame.setMapSelectionItem, FieldWorth.setMapSelectionItem)
	InGameMenuMapFrame.setMapInputContext = Utils.appendedFunction(InGameMenuMapFrame.setMapInputContext, FieldWorth.InGameMenuMapFramesetMapInputContext)
end
Mission00.load = Utils.appendedFunction(Mission00.load, mainLoad)