
JumperCableBreak_Event = {}
local mt = Class(JumperCableBreak_Event, Event)

InitEventClass(JumperCableBreak_Event, "JumperCableBreak_Event")

function JumperCableBreak_Event.emptyNew()
    return Event.new(mt)
end

function JumperCableBreak_Event.new(vehicle)
    local e = JumperCableBreak_Event.emptyNew()
    e.vehicle = vehicle
    return e
end

function JumperCableBreak_Event:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
end

function JumperCableBreak_Event:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self:run(connection)
end

function JumperCableBreak_Event:runOLD(connection)
    if not self.vehicle.isServer then return end

    g_currentMission:addMoney(
        -100,
        self.vehicle:getOwnerFarmId(),
        MoneyType.VEHICLE_REPAIR,
        true,
        true
    )

    g_currentMission:showMoneyChange(MoneyType.VEHICLE_REPAIR)

    g_rvbPlayer.jumperCableConnections = {}
end

function JumperCableBreak_Event:run(connection)
	g_currentMission:addMoney(-100, self.vehicle:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)

	if connection:getIsServer() then
		g_currentMission:showMoneyChange(MoneyType.VEHICLE_REPAIR)
	end
end

function JumperCableBreak_Event.sendEvent(vehicle)
    if g_server ~= nil then
        g_server:broadcastEvent(JumperCableBreak_Event.new(vehicle), nil, nil, vehicle)
    else
        g_client:getServerConnection():sendEvent(JumperCableBreak_Event.new(vehicle))
    end
end
