
JumperCableEvent = {}
local JumperCableEvent_mt = Class(JumperCableEvent, Event)
InitEventClass(JumperCableEvent, "JumperCableEvent")

function JumperCableEvent.emptyNew()
    return Event.new(JumperCableEvent_mt)
end
function JumperCableEvent.new(donor, state, receiver, jumperTime, jumperThreshold)
    local self = JumperCableEvent.emptyNew()
    self.donor = donor print("JumperCableEvent.new donor " ..self.donor:getFullName())
    self.receiver = receiver print("JumperCableEvent.new receiver " ..tostring(self.receiver:getFullName()))
    self.state = state print("JumperCableEvent.new state " ..self.state)
	self.jumperTime = jumperTime
	self.jumperThreshold = jumperThreshold
    return self
end

function JumperCableEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.donor)
    NetworkUtil.writeNodeObject(streamId, self.receiver)
	streamWriteString(streamId, self.state)
	streamWriteInt16(streamId, self.jumperTime)
	streamWriteInt16(streamId, self.jumperThreshold)
end

function JumperCableEvent:readStream(streamId, connection)
    self.donor = NetworkUtil.readNodeObject(streamId)
    self.receiver = NetworkUtil.readNodeObject(streamId)
	self.state = streamReadString(streamId)
	self.jumperTime = streamReadInt16(streamId)
	self.jumperThreshold = streamReadInt16(streamId)
    self:run(connection)
end

function JumperCableEvent:run(connection)
    if self.state == "connect" then
		print("JumperCableEvent run connect")
		self.donor:connectJumperCable(self.receiver, self.jumperTime, self.jumperThreshold, true)
    elseif self.state == "disconnect" then
		print("JumperCableEvent run disconnect")
        self.receiver:disconnectJumperCable(true)
	elseif self.state == "forceDisconnect" then
		print("JumperCableEvent run forceDisconnect")
        self.donor:forceDisconnectJumperCable(true)
    end

    if not connection:getIsServer() then print("JumperCableEvent run not connection:getIsServer()")
        g_server:broadcastEvent(self, false, connection, self.donor)
    end
end


function JumperCableEvent.sendEvent(donor, state, receiver, jumperTime, jumperThreshold, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then print("JumperCableEvent sendEvent g_server")
			g_server:broadcastEvent(JumperCableEvent.new(donor, state, receiver, jumperTime, jumperThreshold), nil, nil, donor)
		else print("JumperCableEvent sendEvent g_client")
			g_client:getServerConnection():sendEvent(JumperCableEvent.new(donor, state, receiver, jumperTime, jumperThreshold))
		end
    end
end
