
RVBPlayer = {}
local RVBPlayer_mt = Class(RVBPlayer)

function RVBPlayer.register()
	return RVBPlayer:new()
end
function RVBPlayer:new()
	local self = {}
	setmetatable(self, RVBPlayer_mt)
	self.vehicle = nil
	self.infoText = ""
	self.jumperCableEventId = nil
	self.pendingDonor = nil
	RVBPlayer.appendedFunction(PlayerInputComponent, "update", self, "PlayerInputComponent_update", false)
	RVBPlayer.appendedFunction(PlayerInputComponent, "registerActionEvents", self, "PlayerInputComponent_registerActionEvents", false)
	return self
end
function RVBPlayer:actionEventConnectJumperCables()
    if self.vehicle == nil then return end

	if self.vehicle.pendingJumperVehicle ~= nil then
		self.vehicle.pendingJumperVehicle = nil
		self.pendingDonor = nil
		self:showWarning("RVB_blinking_disconnecting", self.vehicle)
        return
    end
    local jc = self.vehicle.spec_jumperCable
    if jc ~= nil and jc.connection ~= nil then
        -- LECSATLAKOZTATÁS
        --JumperCableEvent.sendEvent(self.vehicle, "disconnect")
		self.vehicle:disconnectJumperCable()
        return
    end

    -- ===== CONNECT LOGIKA =====
	-- DONOR
    if self.pendingDonor == nil then
        if self.vehicle:getBatteryFillLevelPercentage() > BATTERY_LEVEL.MOTOR + 0.02 then
            self.vehicle.pendingJumperVehicle = self.vehicle
			self.pendingDonor = self.vehicle
			self.vehicle:raiseActive()
            self:showWarning("RVB_blinking_connecting", self.vehicle)
        else
            self:showWarning("RVB_blinking_connecting_order", self.vehicle)
        end
        return
    end

    local donor = self.pendingDonor
    local receiver = self.vehicle

	-- MAR CSATLAKOZTATVA
    if donor == receiver then return end

	-- DONOR MAR NEM LEHET DONOR
    if donor:getBatteryFillLevelPercentage() <= BATTERY_LEVEL.MOTOR then
        donor.pendingJumperVehicle = nil
		self.pendingDonor = nil
        return
    end
	
	-- RECEIVER NEM SZUKSEGES TOLTENI
    if receiver:getBatteryFillLevelPercentage() > BATTERY_LEVEL.MOTOR then
        --donor.pendingJumperVehicle = nil
		--self:showWarning("RVB_dialog_descCONNECTING_JC", self.vehicle)
        --return
    end
	
    if calcDistanceFrom(donor.rootNode, g_localPlayer.rootNode) <= JUMPERCABLE_LENGTH then
		if receiver:getBatteryFillLevelPercentage() <= BATTERY_LEVEL.MOTOR then
			donor:connectJumperCable(receiver)
			donor.pendingJumperVehicle = nil
			self.pendingDonor = nil
			self:showWarning("RVB_blinking_connecting", receiver)
		else
			local title = g_i18n:getText("RVB_dialog_titleCONNECTING_JC")
			local text = string.format(g_i18n:getText("RVB_dialog_descCONNECTING_JC"), self.vehicle:getFullName())
			local callback = self.onYesNoResetVehicleDialog
			local sound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_WRENCH
			YesNoDialog.show(callback, self, text, title, nil, nil, nil, sound)
		end
    end
end
function RVBPlayer.onYesNoResetVehicleDialog(self, yes)
	if yes then
		local donor = self.pendingDonor
		donor:connectJumperCable(self.vehicle)
		donor.pendingJumperVehicle = nil
		self.pendingDonor = nil
		self:showWarning("RVB_blinking_connecting", self.vehicle)
	end
end
function RVBPlayer:getIsValidVehicle(vehicle, farmId)
	return vehicle:getShowInVehiclesOverview() and vehicle:getOwnerFarmId() == farmId
end
function RVBPlayer:PlayerInputComponent_update(inputComponent, dt)
	if inputComponent.player.isOwner and g_inputBinding:getContextName() == PlayerInputComponent.INPUT_CONTEXT_NAME and self.jumperCableEventId ~= nil then
		self.vehicle = nil
		self.infoText = ""
		local farmId = g_currentMission:getFarmId()
		if farmId ~= FarmManager.SPECTATOR_FARM_ID then
			local targetNode = inputComponent.player.targeter:getClosestTargetedNodeFromType(PlayerInputComponent)
			if targetNode ~= nil and entityExists(targetNode) then
				local nodeObject = g_currentMission:getNodeObject(targetNode)
				if nodeObject ~= nil and nodeObject:isa(Vehicle) then -- and self:getIsValidVehicle(nodeObject, farmId) then
					self.vehicle = nodeObject
					local rvb = self.vehicle.spec_faultData
					if rvb == nil or (rvb ~= nil and not rvb.isrvbSpecEnabled) then
						return
					end
					local isConnected = false
					if self.vehicle.pendingJumperVehicle ~= nil and self.vehicle.pendingJumperVehicle == self.vehicle then
						isConnected = true
					end
					local jc = self.vehicle.spec_jumperCable
					if jc ~= nil and jc.connection ~= nil then
						isConnected = true
					end
					self.infoText = g_i18n:getText(isConnected and "action_RVB_DISCONNECTING_JC" or "input_RVB_CONNECTING_JC")
				end
			end
		end
		g_inputBinding:setActionEventTextPriority(self.jumperCableEventId, GS_PRIO_VERY_HIGH)
		g_inputBinding:setActionEventTextVisibility(self.jumperCableEventId, self.vehicle ~= nil and self.vehicle.spec_faultData ~= nil)
		g_inputBinding:setActionEventActive(self.jumperCableEventId, self.vehicle ~= nil and self.vehicle.spec_faultData ~= nil)
		g_inputBinding:setActionEventText(self.jumperCableEventId, self.infoText)
	end
end
function RVBPlayer:PlayerInputComponent_registerActionEvents(inputComponent)
	if inputComponent.player.isOwner then
		g_inputBinding:beginActionEventsModification(PlayerInputComponent.INPUT_CONTEXT_NAME)
		local _, jumperCableEventId = g_inputBinding:registerActionEvent(InputAction.RVB_CONNECTING_JC, self, self.actionEventConnectJumperCables, false, true, false, false, nil, true)
		self.jumperCableEventId = jumperCableEventId
		g_inputBinding:endActionEventsModification()
	end
end
function RVBPlayer:showWarning(messageKey, vehicle)
    g_currentMission:showBlinkingWarning(string.format(g_i18n:getText(messageKey), vehicle:getFullName()), 2000)
end
function RVBPlayer.appendedFunction(oldTarget, oldFunc, newTarget, newFunc)
	local superFunc = oldTarget[oldFunc]
	oldTarget[oldFunc] = function(...)
		superFunc(...)
		newTarget[newFunc](newTarget, ...)
	end
end